/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xtrcdefs.h
 * -----------------------------------------------------------------*/

#ifndef XTRCDEFS_H_INCLUDED                               
#define XTRCDEFS_H_INCLUDED

#ifndef CLI
#define CLI
#endif


/* ---------------------------------------------------------------
 * Type Definitions for Analyzer & External Trigger Functions
 * --------------------------------------------------------------- */

/* This enum represents the different status information the analyzer
   can send back to the user*/
CLI typedef enum {
  BX_TRC_STAT,          /* @stat */
  BX_TRC_TRIGPOINT,     /* @trig */
  BX_TRC_LINESCAPT      /* @lines */
} bx_tracestatustype;


#define BX_TRACEPROP_SIZE 3

CLI typedef enum {
  BX_TRACE_HEARTBEATMODE,   /* @heartbeatmode  */
  BX_TRACE_HEARTBEATVALUE,  /* @heartbeatvalue */
  BX_TRACE_TRIG_HISTORY     /* @trighistory    */
} bx_tracetype;

CLI  /* DEF_START ~G_BX_TraceProp */
#define BX_TRACE_HEARTBEATMODE_ON  1
#define BX_TRACE_HEARTBEATMODE_OFF 0
CLI /* DEF_END */

#define    BX_PATT_TERM_TRIG 21
#define    BX_PATT_TERM_SQ   22


#if 0

#define    BX_PATT_TERM_21   21  /* @pt21      */
#define    BX_PATT_TERM_22   22  /* @pt22      */
#define    BX_PATT_TERM_23   23  /* @pt23      */
#define    BX_PATT_TERM_24   24  /* @pt24      */
#define    BX_PATT_TERM_25   25  /* @pt25      */
#define    BX_PATT_TERM_26   26  /* @pt26      */
#define    BX_PATT_TERM_27   27  /* @pt27      */
#define    BX_PATT_TERM_28   28  /* @pt28      */
#define    BX_PATT_TERM_29   29  /* @pt29      */

#endif

#define    BX_PATT_FAST_0    32  /* @fpt0      */
#define    BX_PATT_FAST_1    33  /* @fpt1      */
#define    BX_PATT_FAST_2    34  /* @fpt2      */
#define    BX_PATT_FAST_3    35  /* @fpt3      */
#define    BX_PATT_FAST_4    36  /* @fpt4      */
#define    BX_PATT_FAST_5    37  /* @fpt5      */
#define    BX_PATT_FAST_6    38  /* @fpt6      */
#define    BX_PATT_FAST_7    39  /* @fpt7      */

#define    BX_PATT_TERM_TRAN 40


#endif


